<h2>{{ __('app.apps.config') }} ({{ __('app.optional') }}) @include('items.enable')</h2>
<div class="items">
    <div class="input">
        <label>{{ strtoupper(__('app.url')) }}</label>
        {!! Form::text('config[override_url]', isset($item) ? $item->getconfig()->override_url : null, ['placeholder' => __('app.apps.override'), 'id' => 'override_url', 'class' => 'form-control']) !!}
    </div>
    <div class="input">
        <label>Service</label>
        {!! Form::text('config[service]', isset($item) ? $item->getconfig()->service : 'jaeger-query', ['placeholder' => 'Service, e.g. jaeger-query', 'data-config' => 'service', 'class' => 'form-control config-item']) !!}
    </div>
    <div class="input">
        <label>Operation</label>
        {!! Form::text('config[operation]', isset($item) ? $item->getconfig()->operation : null, ['placeholder' => 'Operation, e.g. /api/traces', 'data-config' => 'operation', 'class' => 'form-control config-item']) !!}
    </div>
</div>
<div class="items">
    <div class="input">
        <label>{{ __('app.apps.tags') }}</label>
        {!! Form::text('config[tags]', isset($item) ? $item->getconfig()->tags : null, ['placeholder' => __('app.apps.tags'), 'data-config' => 'tags', 'class' => 'form-control config-item']) !!}
    </div>
    <div class="input">
        <label>Lookback</label>
        {!! Form::select(
            'config[lookback]',
            ['1h' => 'Last Hour', '2h' => 'Last 2 Hours', '3h' => 'Last 3 Hours', '6h' => 'Last 6 Hours', '12h' => 'Last 12 Hours', '24h' => 'Last 24 Hours', '2d' => 'Last 2 Days'],
            isset($item) ? $item->getconfig()->lookback : null,
            ['data-config' => 'lookback', 'class' => 'form-control config-item'],
        ) !!}
    </div>
    <div class="input">
        <label>Limit</label>
        {!! Form::text('config[limit]', isset($item) ? $item->getconfig()->limit : 100, ['placeholder' => 'Limit results', 'data-config' => 'limit', 'class' => 'form-control config-item']) !!}
    </div>
</div>
<div class="items">
    <div class="input">
        <label>Min Duration</label>
        {!! Form::text('config[minDuration]', isset($item) ? $item->getconfig()->minDuration : null, ['placeholder' => 'e.g. 1.2s, 100ms, 500us', 'data-config' => 'minDuration', 'class' => 'form-control config-item']) !!}
    </div>
    <div class="input">
        <label>MaxDuration</label>
        {!! Form::text('config[maxDuration]', isset($item) ? $item->getconfig()->maxDuration : null, ['placeholder' => 'e.g. 1.2s, 100ms, 500us', 'data-config' => 'maxDuration', 'class' => 'form-control config-item']) !!}
    </div>
    <div class="input">
        <button style="margin-top: 32px;" class="btn test" id="test_config">Test</button>
    </div>
</div>
